// Para6.cpp : implementation file
//

#include "stdafx.h"
#include "3D Printer.h"

#include "3D PrinterDlg.h"

#include "typedef.h"
#include "Delay.h"
#include "Command.h"
#include <math.h>
#include "usbprint.h"
static CPara4* pDlg=NULL;
extern unsigned char CheckDevice(void);
extern volatile   BOOL UsbConnect;
extern double Hour;
extern volatile BOOL bDeviceChange;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPara4 dialog


CPara4::CPara4(CWnd* pParent /*=NULL*/)
	: CDialog(CPara4::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPara4)
	m_UvPower = 1000;
	m_Uv_k = 0.0083f;
	m_Uv_b = 0.0199f;
	//}}AFX_DATA_INIT
}


void CPara4::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPara4)
	DDX_Control(pDX, IDC_DEVICE_INDEX, m_DeviceIndex);
	DDX_Text(pDX, IDC_UV_POWER, m_UvPower);
	DDV_MinMaxUInt(pDX, m_UvPower, 1, 2000);
	DDX_Text(pDX, IDC_UV_K, m_Uv_k);
	DDX_Text(pDX, IDC_UV_B, m_Uv_b);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPara4, CDialog)
	//{{AFX_MSG_MAP(CPara4)
	ON_WM_CLOSE()
	ON_CBN_SELCHANGE(IDC_DEVICE_INDEX, OnSelchangeDeviceIndex)
	ON_BN_CLICKED(IDC_UV_POWER_SET, OnUvPowerSet)
	ON_BN_CLICKED(IDC_UV_POWER_GET, OnUvPowerGet)
	ON_BN_CLICKED(IDC_LED_UV_GET, OnLedUvGet)
	ON_BN_CLICKED(IDC_UV_PARA_SET, OnUvParaSet)
	ON_BN_CLICKED(IDC_UV_PARA_GET, OnUvParaGet)
	ON_EN_CHANGE(IDC_UV_K, OnChangeUvK)
	ON_EN_CHANGE(IDC_UV_B, OnChangeUvB)
	ON_BN_CLICKED(IDC_UV_AUTO_ON, OnUvAutoOn)
	ON_BN_CLICKED(IDC_UV_AUTO_OFF, OnUvAutoOff)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPara4 message handlers
static BOOL f_first=TRUE;
BOOL CPara4::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CString DevIndex;
	//unsigned int i;
	float k,b;
	pDlg=this;
	// TODO: Add extra initialization here
	if(f_first)
    {
		_CWndCS(this);
		/*
		m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
			DevIndex.Format(" %d ",i);
			m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_DeviceIndex.AddString(" XXX ");
		m_DeviceIndex.SetCurSel(0);
		*/
		k=0.0083f;
		b=0.0199f;
		m_Uv_k = k;
	    m_Uv_b = b;
	    UpdateData(FALSE);
		f_first=FALSE;
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


BOOL CPara4::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_ESCAPE) 
		return TRUE; 
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN) 
		return TRUE;
	return CDialog::PreTranslateMessage(pMsg);
}


void CPara4::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnClose();
}

void CPara4::OnSelchangeDeviceIndex() 
{
	// TODO: Add your control notification handler code here
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	HWND hwndStatusBar=p->m_StatusBar.GetSafeHwnd();
	HWND hwndLedIndex=p->m_para1.m_LedIndex.GetSafeHwnd();
	U32 UseTime;
	CString StrHour;
	CString StrLedDefaultStatus;
	U8 Value=0,Index;
	CString StrVal;
	//unsigned char flag;
	unsigned char ID[8];
	CString StrTxt;
	if(p->m_para5.IspWorking)
	{
		UpdateData(FALSE);
		return;
	}
	if(bDeviceChange)
		return;
	if(USBDeviceInfo.count==0)
		return;
	UpdateData(TRUE);
	USBDevIndex=m_DeviceIndex.GetCurSel();
	if(CheckUSBOnline()==FALSE)
	{
		StrTxt=" " + _CS("WarningGeneral.DeviceDisconnect");
		::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		StrTxt="SN: XX-XX-XX-XX-XX-XX";
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		UsbConnect=FALSE;
		return;
	}
	StrTxt=" " + _CS("WarningGeneral.DeviceConnect");
	::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
	UsbConnect=TRUE;
	//if(strcmp(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0])==0)
	//	return;
	memset(DeviceName,0,MAX_PATH);
	strcpy(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0]);
	if(CheckDevice()==1)
	{
		if(GetLedDefaultStatus(&Value))
		{
			if(Value)
				StrLedDefaultStatus=_CS("Led.Off");
			else
				StrLedDefaultStatus=_CS("Led.On");
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
		}
		GetProductID(ID);
		StrTxt.Format("SN: %02X-%02X-%02X-%02X-%02X-%02X",ID[0],ID[1],ID[2],ID[3],ID[4],ID[5]);
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		//----------------------------------
		Index=(int)::SendMessage(hwndLedIndex, CB_GETCURSEL, 0, 0);
		//Index=m_para1.m_LedIndex.GetCurSel();
		if(GetCurrent(Index,&Value)==FALSE)
			return;	
		if(Value>100)
			return;
		StrVal.Format("%d",Value);
		p->m_para1.m_Slider_Led.SetPos(Value);
		p->m_para1.SliderPos=Value;
		::SetDlgItemText(p->m_para1.GetSafeHwnd(),IDC_EDIT_LED,StrVal);
		if(GetUseTime(&UseTime))
		{
			Hour=UseTime/(3600.0f);
			StrHour.Format("%.1f",Hour);
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_USE_HOUR,StrHour);
		}
        /*
		if(GetUvPower(&u16Value))
		{
			p->m_para4.m_UvPower=u16Value;
			StrVal.Format("%d",u16Value);
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_UV_POWER,StrVal);
		}
		if(GetUvAuto(&bAuto))
		{
			if(bAuto)
				CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_ON);
			else
				CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_OFF);
		}
		*/
	}
}

void CPara4::OnUvPowerSet() 
{
	// TODO: Add your control notification handler code here
	int   iRadioButton;
	BOOLEAN flag;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	UpdateData(TRUE);
	if(SetUvPower(m_UvPower)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	   
	iRadioButton=GetCheckedRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF); 

	if(iRadioButton==IDC_UV_AUTO_ON)
		flag=1;
	else
		flag=0;
	
	if(SetUvAuto(flag)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
	}
}

void CPara4::OnUvPowerGet() 
{
	// TODO: Add your control notification handler code here
	BOOLEAN flag;
	U16 Value;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(GetUvPower(&Value)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	m_UvPower=Value;
	UpdateData(FALSE);
	if(GetUvAuto(&flag)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(flag)
		CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_ON);
	else
		CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_OFF);
}


void CPara4::OnLedUvGet() 
{
	// TODO: Add your control notification handler code here
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	U16 Value;
	CString StrVal;
	U8 Index,LedVal;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(GetUvValue(&Value)==FALSE)
	{
		StrVal="XXXXX";
		SetDlgItemText(IDC_UV_VALUE,StrVal);
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	StrVal.Format("%d",Value);
	SetDlgItemText(IDC_UV_VALUE,StrVal);
	//----------------------------------------	
	Index=p->m_para1.m_LedIndex.GetCurSel();
	if(GetCurrent(Index,&LedVal)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	
	if(LedVal>100)
	{
		MessageBox(_CS("WarningUart.ReadFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	StrVal.Format("%d",LedVal);
	SetDlgItemText(IDC_LED_VALUE,StrVal);
	if(GetUvPower(&Value)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	m_UvPower=Value;
	UpdateData(FALSE);
	StrVal.Format("%d",Value);
	SetDlgItemText(IDC_UV_POWER_DISP,StrVal);
}

void CPara4::OnUvParaSet() 
{
	// TODO: Add your control notification handler code here
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	UpdateData(TRUE);
	if(SetUvPara(m_Uv_k,m_Uv_b)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
}

void CPara4::OnUvParaGet() 
{
	// TODO: Add your control notification handler code here
	float k,b;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(GetUvPara(&k,&b)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	m_Uv_k=k;
	m_Uv_b=b;
	UpdateData(FALSE);
	GetDlgItem(IDC_UV_K)->EnableWindow(TRUE);
	GetDlgItem(IDC_UV_B)->EnableWindow(TRUE);
	GetDlgItem(IDC_UV_PARA_SET)->EnableWindow(TRUE);
}

void CPara4::OnChangeUvK() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CPara4::OnChangeUvB() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CPara4::OnUvAutoOn() 
{
	// TODO: Add your control notification handler code here
	OnUvPowerSet();
}

void CPara4::OnUvAutoOff() 
{
	// TODO: Add your control notification handler code here
	OnUvPowerSet();	
}
